% function [energycell, speccell] = PlottingSpectra_STXM()

dirlist = uipickfiles();
cnt = 1;
for dd = 1:length(dirlist)
	
	load(dirlist{dd},'Snew');
	
	for pp = 1:length(Snew.PartLabel)
		
		currpartmask = NaN(size(Snew.LabelMat));
		currpartmask(Snew.LabelMat == pp) = 1;
		backmask = NaN(size(Snew.LabelMat));
		backmask(Snew.LabelMat == 0) = 1;
		
		spec = Snew.spectr;
		maskedspec = bsxfun(@times,spec,currpartmask);
		maskedbackspec = bsxfun(@times,spec,backmask);
		backspec = squeeze(nanmean(nanmean(maskedbackspec)));
		
		partspec = squeeze(nanmean(nanmean(maskedspec)));
		partspec = partspec - backspec;
		partenergy = Snew.eVenergy;
		%partspec = NormalizeSpectra(partenergy,partspec);
		
		backspecmat(cnt,:) = backspec;
		specmat(cnt,:) = partspec;
		energymat(cnt,:) = Snew.eVenergy;
		
		cnt = cnt + 1;
	end
end
energy = energymat(1,:);
avgspec = mean(specmat,1);
stderrspec = std(avgspec) .* 2.45 ./ sqrt(6);
upspec = avgspec + stderrspec;
lowspec = avgspec - stderrspec;

figure; hold on; 
for i=1:size(specmat,1) 
	plot(energy,specmat(i,:)); 
end


% figure; hold on;
% plot(energy,avgspec);
% % plot(energy,upspec,'Color',[0.8,0.8,0.8],'LineWidth',1);
% % plot(energy,lowspec,'Color',[0.8,0.8,0.8],'LineWidth',1);
% axis square
% set(gca,...
% 	'FontWeight','bold',...
% 	'FontSize',20,...
% 	'XLim',[278,320],...
% 	'YLim',[-0.1,4.2],...
% 	'Color','none');
% xlabel('Energy (eV)');
% ylabel('Optical Density (a.u.)');